#include <a_samp>
#include <YSI\y_hooks>

#if defined _excel_included
#endinput
#endif
#define _excel_included
#pragma library excel

//==========================| Messages |========================================
/* Thanks To SA-MP team too */

/*
native (( e_messages ))
native E_TextdrawMessage(playerid, text[])
native E_PlayerMessage(playerid, color, message[])
native E_GlobalMessage(color, message[])
native E_UsageMsg(playerid, message[])
native E_ErrorMsg(playerid, message[])
native E_AdminMsg(playerid, message[])
native E_AdminMsgEx(playerid, message[])
native E_LocalMessage(Float:dist, playerid, color, message[], chatbubble=0)
native E_TalkMessage(Float:dist, playerid, prefix[], message[])
native _
*/

#define GENERAL_COLOR      	0xEEEEEEFF
#define LOCAL_TALK_COLOR    0xD0D0D0FF
#define SPEECH_BUBBLE_COLOR	0xEEEEEEFF
#define ACTION_COLOR     	0xC2A2DAAA
#define CMD_USAGE_COLOR     0xBFC0C2FF
#define MEGAPHONE_COLOR		0xFFFF00AA
#define WHISPER_COLOR		0xFFFF00AA
#define OOC_COLOR			0xE0FFFFAA
#define ADMIN_ACTION_COLOR  0xDAA2ACAA

#define TALK_DISTANCE   	30.0
#define SHOUT_DISTANCE  	60.0
#define LOW_DISTANCE    	5.0
#define ACTION_DISTANCE 	30.0
#define MEGAPHONE_DISTANCE  70.0
#define CHAT_BUBBLE_TIME 	6000
#define ACTION_ME           1
#define ACTION_DO           2

//---------------------------------------------
//Send Player a textdraw message
new PlayerText:E_Message;
stock E_TextdrawMessage(playerid, text[])
{
	PlayerTextDrawDestroy(playerid, E_Message);
    Message = CreatePlayerTextDraw(playerid, 370.000000, 360.000000, text);
	PlayerTextDrawBackgroundColor(playerid, E_Message, 255);
	PlayerTextDrawFont(playerid, E_Message, 1);
	PlayerTextDrawLetterSize(playerid, E_Message, 0.440000, 1.600000);
	PlayerTextDrawColor(playerid, E_Message, -1);
	PlayerTextDrawSetOutline(playerid, E_Message, 1);
	PlayerTextDrawSetProportional(playerid, E_Message, 1);
	PlayerTextDrawUseBox(playerid, E_Message, 1);
	PlayerTextDrawBoxColor(playerid, E_Message, 0);
	PlayerTextDrawTextSize(playerid, E_Message, 591.000000, 0.000000);
	TextDrawShowForPlayer(playerid, E_Message);
	SetTimerEx("E_ExpireTextdrawMessage", 5000, false, "i", playerid);
}
forward E_ExpireTextdrawMessage(playerid);
public E_ExpireTextdrawMessage(playerid)
{ return PlayerTextDrawDestroy(playerid, E_Message), PlayerTextDrawHide(playerid, E_Message), KillTimer(E_ExpireTextdrawMessage(playerid)); }

//---------------------------------------------
// Send a chat message to this player
stock E_PlayerMessage(playerid, color, message[])
{	SendClientMessage(playerid, color, message);	}

//---------------------------------------------
// Send a chat message to all players
stock E_GlobalMessage(color, message[])
{	SendClientMessageToAll(color, message);	}

//---------------------------------------------
stock E_UsageMsg(playerid, message[])
{	new msg[256+1];	format(msg,256,"[{BFC0C2}Usage{EEEEEE}] %s", message);	SendClientMessage(playerid, GENERAL_COLOR, msg);	}

//---------------------------------------------
stock E_ErrorMsg(playerid, message[])
{	new msg[256+1]; format(msg,256,"[{E0C0C0}Error{EEEEEE}] %s", message); SendClientMessage(playerid, GENERAL_COLOR, msg); }

//---------------------------------------------
stock E_AdminMsg(playerid, message[])
{	new msg[256+1]; format(msg,256,"[{5050EE}Admin{EEEEEE}] %s", message);	SendClientMessage(playerid, GENERAL_COLOR, msg); }

//---------------------------------------------
stock E_AdminMsgEx(playerid, message[])
{	PlayerPlaySound(playerid, 1052, 0.0, 0.0, 0.0);	SendClientMessage(playerid, ADMIN_ACTION_COLOR, message);	}

//---------------------------------------------
// Send a chat message to players in distance of playerid, This includes the origin player.
stock E_LocalMessage(Float:dist, playerid, color, message[], chatbubble=0)
{
	if(!strlen(message)) return;
	if(IsPlayerConnected(playerid))
	{
		new Float:fPlayerX, Float:fPlayerY, Float:fPlayerZ;
		new Float:fPlayerToPlayerDist;
		// send to the origin player
		PlayerMessage(playerid, color, message);
		// if it requires a chat bubble, show it.
		if(chatbubble)
		{	SetPlayerChatBubble(playerid, message, color, dist, CHAT_BUBBLE_TIME);	}
		GetPlayerPos(playerid, fPlayerX, fPlayerY, fPlayerZ);
		for(new i = 0; i < MAX_PLAYERS; i++) { // for every player
		    if(IsPlayerConnected(i) && (i != playerid) && IsPlayerStreamedIn(playerid,i)) {
		        fPlayerToPlayerDist = GetPlayerDistanceFromPoint(i, fPlayerX, fPlayerY, fPlayerZ);
				if(fPlayerToPlayerDist < dist) { // receiving player is within the specified distance
					PlayerMessage(i, color, message);
				}
			}
		}
	}
}

//---------------------------------------------
// This will send a local talk message and automatically grey-fade it. This includes the origin player.
stock E_TalkMessage(Float:dist, playerid, prefix[], message[])
{
    new PlayerName[MAX_PLAYER_NAME+1];
	new Msg[256+1];
	new MsgWithName[256+1];
	if(!strlen(message)) return;
	if(IsPlayerConnected(playerid))
	{
		new Float:fPlayerX, Float:fPlayerY, Float:fPlayerZ;
		new Float:fPlayerToPlayerDist;
		new Float:fNormDistance;
		new ColorScale;
		new ColorValue;
		GetPlayerName(playerid, PlayerName, sizeof(PlayerName));
		if(strlen(prefix))
		{	format(Msg, sizeof(Msg), "%s %s", prefix, message);
		} else
		{	format(Msg, sizeof(Msg), "%s", message);	}
		format(MsgWithName, sizeof(MsgWithName), "%s: %s", PlayerName, Msg);
        SetPlayerChatBubble(playerid, Msg, SPEECH_BUBBLE_COLOR, dist, CHAT_BUBBLE_TIME);
		// Send to originating player
		PlayerMessage(playerid, LOCAL_TALK_COLOR, MsgWithName);
		GetPlayerPos(playerid, fPlayerX, fPlayerY, fPlayerZ);
		for(new i = 0; i < MAX_PLAYERS; i++) { // for every player
		    if(IsPlayerConnected(i) && (i != playerid) && IsPlayerStreamedIn(playerid,i)) {
		        fPlayerToPlayerDist = GetPlayerDistanceFromPoint(i, fPlayerX, fPlayerY, fPlayerZ);
				if(fPlayerToPlayerDist < dist) { // receiving player is within the specified distance
					// get normalized distance to create a fade.
					fNormDistance = 1.0 - (fPlayerToPlayerDist / dist);
  					if(fNormDistance > 0.75) ColorScale = 220;
					else ColorScale = floatround(96.0 + (128.0 * fNormDistance));
					ColorValue = 0x000000FF | ColorScale << 24 | ColorScale << 16 | ColorScale << 8;
					PlayerMessage(i, ColorValue, MsgWithName);
				}
			}
		}
	}
}

//=============================| E_ini |========================================
/* Thanks To Southclaw too */

/*
native (( e_file ))
native E_CreateFile(filename[])
native E_DeleteFile(filename[])
native _
native E_OpenFile(filename[])
native E_SaveFile(filename[])
native E_CloseFile()
native _
native E_WriteString(key[], value[])
native E_WriteVal(key[], value)
native E_WriteFloat(key[], Float:value)
native E_RemoveKey(key[])
native E_RenameKey(key[], newname[MAX_KEY_LENGTH])
native _
native E_ReadString(key[], dest[])
native E_ReadVal(key[])
native E_ReadFloat(key[])
native E_IsKey(key[])
native _
native E_PrintAllFile()
native E_MultiWrite(type[],{Float,_}:...)
native _
*/

#define MAX_RECORDS         (999)
#define MAX_KEY_LENGTH      (32)
#define MAX_VAL_LENGTH      (256)
#define MAX_RECORD_LENGTH   (MAX_KEY_LENGTH + MAX_VAL_LENGTH + 2)
#define __isnull(%0)        (%0[0] == 0||(%0[0] == 1&&%0[1] == 0))
#define __strcpy(%0,%1,%2)  strcat((%0[0] = '\0', %0), %1, %2)

enum	{	WINDOWS,LINUX	}
static
File:	ini_CurrentFile,
		ini_Temp[MAX_RECORD_LENGTH],
		ini_OsLineEndLen = 2,
		ini_OsLineEndChar[5],
bool:	ini_FileOpen,
		ini_KeyData[MAX_RECORDS][MAX_KEY_LENGTH],
		ini_ValData[MAX_RECORDS][MAX_VAL_LENGTH];

public OnGameModeInit()
{
	new type = LINUX;
	fclose(fopen("windows", io_write));
	if(fexist("WINDOWS"))
		type = WINDOWS;
	fremove("windows");
	if(type == WINDOWS)
	{
		ini_OsLineEndLen = 2;
		ini_OsLineEndChar = "\r\n";
	} else {
		ini_OsLineEndLen = 1;
		ini_OsLineEndChar = "\n";
	}
	return CallLocalFunction("inifiles_OnGameModeInit", "");
}
#if defined _ALS_OnGameModeInit
	#undef OnGameModeInit
#else
	#define _ALS_OnGameModeInit
#endif
#define OnGameModeInit inifiles_OnGameModeInit
forward inifiles_OnGameModeInit();

stock E_CreateFile(filename[])
{
	if(fexist(filename))
	{
		printf("ERROR CREATING FILE : '%s' : FILE ALREADY EXISTS", filename);
		return 0;
	}
	ini_CurrentFile = fopen(filename, io_write);
	fclose(ini_CurrentFile);
	return 1;
}

stock E_DeleteFile(filename[])
{
	fremove(filename);
	return 1;
}

stock E_OpenFile(filename[])
{
	if(!fexist(filename))
	{
		printf("ERROR: E_OpenFile: File '%s' not found.", filename);
		return 0;
	} else ini_CurrentFile = fopen(filename, io_read);
	new i, delim;
	while(fread(ini_CurrentFile, ini_Temp) && (i < MAX_RECORDS))
	{
		if(strlen(ini_Temp) && strfind(ini_Temp, ini_OsLineEndChar) != -1) strdel(ini_Temp, strlen(ini_Temp) - ini_OsLineEndLen, strlen(ini_Temp));
		delim = strfind(ini_Temp, "=");
		if(delim != -1)
		{
			__strcpy(ini_KeyData[i], ini_Temp, delim + 1);
			__strcpy(ini_ValData[i], ini_Temp[delim + 1], MAX_VAL_LENGTH);

			if(ini_KeyData[i][delim - 1] == ' ')
				strdel(ini_KeyData[i], delim - 1, delim);

			if(!ini_ValData[i][0])
				strdel(ini_ValData[i], -1, 0);
		} else {
			ini_KeyData[i][0] = 0;
			__strcpy(ini_ValData[i], ini_Temp, MAX_VAL_LENGTH);
		}
		i++;
	}
	ini_FileOpen = true;
	ini_Temp[0] = '\0';
	fclose(ini_CurrentFile);
	return 1;
}

stock E_SaveFile(filename[])
{
	if(!fexist(filename))
	{
		printf("Error: E_SaveFile: File '%s' not found.", filename);
		return 0;
	}
	if(!ini_FileOpen)
	{
		print("Error: E_SaveFile: No file has been opened.");
		return 0;
	}
	new i;
	ini_CurrentFile = fopen(filename, io_write);
	while(i < MAX_RECORDS)
	{
		if(file_IsLineNull(i))
			break;

		if(file_IsLineMarkedToSkip(i))
			continue;

		if(file_IsLineComment(i))
		{
			__strcpy(ini_Temp, ini_ValData[i], MAX_RECORD_LENGTH);
			strcat(ini_Temp, ini_OsLineEndChar);
		} else format(ini_Temp, MAX_RECORD_LENGTH, "%s = %s%s", ini_KeyData[i], ini_ValData[i], ini_OsLineEndChar);
		fwrite(ini_CurrentFile, ini_Temp);
		i++;
	}
	fclose(ini_CurrentFile);
	return 1;
}

stock E_CloseFile()
{
	for(new i; i < MAX_RECORDS; i++)
	{
		ini_KeyData[i][0] = '\0';
		ini_ValData[i][0] = '\0';
	}
	ini_FileOpen = false;
	ini_CurrentFile = File:0;
	ini_Temp[0] = '\0';
	return 1;
}

stock E_WriteString(key[], value[])
{
	if(!ini_FileOpen)
	{
		printf("Error: E_WriteString: No file was opened.");
		return 0;
	}
	new i = file_FindLine(key);

	__strcpy(ini_KeyData[i], key, MAX_KEY_LENGTH);
	__strcpy(ini_ValData[i], value, MAX_VAL_LENGTH);
	return 1;
}

stock E_WriteVal(key[], value)
{
	if(!ini_FileOpen)
	{
		printf("Error: E_WriteVal: No file was opened.");
		return 0;
	}
	new i = file_FindLine(key);
	__strcpy(ini_KeyData[i], key, MAX_KEY_LENGTH);
	format(ini_ValData[i], MAX_VAL_LENGTH, "%d", value);
	return 1;
}

stock E_WriteFloat(key[], Float:value)
{
	if(!ini_FileOpen)
	{
		printf("Error: E_WriteFloat: No file was opened.");
		return 0;
	}
	new i = file_FindLine(key);
	__strcpy(ini_KeyData[i], key, MAX_KEY_LENGTH);
	format(ini_ValData[i], MAX_VAL_LENGTH, "%f", value);
	return 1;
}

stock E_RemoveKey(key[])
{
	if(!ini_FileOpen)
	{
		printf("Error: E_RemoveKey: No file was opened.");
		return 0;
	}
	new i;
	while(i < MAX_RECORDS)
	{
		if(file_IsLineNull(i))
			return 0;
		if(!strcmp(ini_KeyData[i], key))
		{
			ini_KeyData[i][0] = 0x1E;
			ini_ValData[i][0] = 0x1E;
			break;
		}
		i++;
	}
	return 1;
}

stock E_MultiWrite(type[],{Float,_}:...)
{
	new
		i = 0x-1;
    while(++i<strlen(type))
    {
        new
			l = 0x-1,
            iLoop = -1,
            string2[512],
            paramtar[0x80];
        while(++l<0x80) paramtar[l] = getarg(1 + (i * 2), l);
        switch(type[i])
        {
			case 'i': E_WriteVal(paramtar, getarg(2 + (i * 2)));
			case 'd': E_WriteVal(paramtar, getarg(2 + (i * 2)));
			case 'f': E_WriteFloat(paramtar, Float:(getarg(2 + (i * 2))));
			case 's':
			{
				while((++iLoop != 0x100)) string2[iLoop] = getarg(2 + (i * 2), iLoop);
    			E_WriteString(paramtar, string2);
 			}
		}
	}
	return false;
}

stock E_RenameKey(key[], newname[MAX_KEY_LENGTH])
{
	if(!ini_FileOpen)
	{
		printf("Error: E_RenameKey: No file was opened.");
		return 1;
	}
	new i;
	while(i < MAX_RECORDS)
	{
		if(file_IsLineNull(i))
			return 0;;

		if(!strcmp(ini_KeyData[i], key))
			break;

		i++;
	}
	__strcpy(ini_KeyData[i], newname, MAX_KEY_LENGTH);
	return 1;
}

stock E_ReadString(key[], dest[], len = sizeof(dest))
{
	if(!ini_FileOpen)
	{
		printf("Error: E_ReadString: No file was opened.");
		return 0;
	}
	for(new i; i < MAX_RECORDS; i++)
	{
		if(file_IsLineNull(i))
			break;
		if(!strcmp(ini_KeyData[i], key, false, MAX_KEY_LENGTH))
		{
			dest[0] = EOS;
			strcat(dest, ini_ValData[i], len);
			return 1;
		}
	}
	return 0;
}

stock E_ReadVal(key[])
{
	if(!ini_FileOpen)
	{
		printf("Error: E_ReadVal: No file was opened.");
		return 0;
	}
	for(new i; i < MAX_RECORDS; i++)
	{
		if(file_IsLineNull(i))
			break;

		if(!strcmp(ini_KeyData[i], key, false, MAX_KEY_LENGTH))
			return strval(ini_ValData[i]);
	}
	return 0;
}

stock Float:E_ReadFloat(key[])
{
	if(!ini_FileOpen)
	{
		printf("Error: E_ReadFloat: No file was opened.");
		return 0.0;
	}
	for(new i; i < MAX_RECORDS; i++)
	{
		if(file_IsLineNull(i))
			break;

		if(!strcmp(ini_KeyData[i], key, false, MAX_KEY_LENGTH))
			return floatstr(ini_ValData[i]);
	}
	return Float:0.0;
}

stock E_IsKey(key[])
{
	if(!ini_FileOpen)
	{
		printf("Error: E_IsKey: No file was opened.");
		return 0;
	}
	for(new i; i < MAX_RECORDS; i++)
	{
		if(file_IsLineNull(i))
			break;

		if(!strcmp(ini_KeyData[i], key, false, MAX_KEY_LENGTH))
			return true;
	}
	return false;
}

stock E_PrintAllFile()
{
	if(!ini_FileOpen)
	{
		printf("Error: E_PrintAllFile: No file was opened.");
		return 0;
	}
	new i;
	while(i<MAX_RECORDS)
	{
		if(file_IsLineMarkedToSkip(i))
			continue;
		if(file_IsLineNull(i))
			break;
		printf("[ID:%d] %s = %s", i, ini_KeyData[i], ini_ValData[i]);

		i++;
	}
	return 1;
}

stock file_IsLineNull(id)
{
	if(__isnull(ini_KeyData[id]) && __isnull(ini_ValData[id]))
		return 1;
	return 0;
}

stock file_IsLineMarkedToSkip(id)
{
	if(ini_KeyData[id][0] == 0x1E)
		return 1;
	return 0;
}

stock file_IsLineComment(id)
{
	if(__isnull(ini_KeyData[id]) && !__isnull(ini_ValData[id]))
		return 1;
	return 0;
}

stock file_FindLine(key[])
{
	new i;
	while(i < MAX_RECORDS)
	{
		if(file_IsLineMarkedToSkip(i))
			continue;
		if(file_IsLineNull(i))
			break;
		if(!strcmp(ini_KeyData[i], key, false, MAX_KEY_LENGTH))
			break;
		i++;
	}
	return i;
}

//=============================| E_Static |=====================================
/* Thanks To SAMP Team too */

/*
native (( e_static ))
native IsPlayerSpawned(playerid)
native IsPlayerDead(playerid)
native IsPlayerInClassSelection(playerid)
native IsPlayerOnBike(playerid)
native IsPlayerInCar(playerid)
native IsPlayerInBoat(playerid)
native IsPlayerInHelicopter(playerid)
native IsPlayerInAircraft(playerid)
native IsPlayerAfk(playerid)
native IsPlayerInjured(playerid)
native IsPlayerGod(playerid)
native IsPlayerMale(playerid)
native IsPlayerFemale(playerid)
native IsPlayerInWater(playerid)
native IsPlayerOnLand(playerid)
native _
*/

#define \
	ENABLE  \
	    1
#define \
	DISABLE  \
	    0
#define \
    AFK_TIMER   \
        30000

enum
	p_data_vars
{
	spawned,
	dead,
	class,
	afk,
	afktimer

}
new
	player_info[	MAX_PLAYERS	][   p_data_vars ];
forward OnPlayerUpdateEx(playerid);

stock IsPlayerSpawned(playerid)
{
	if(player_info[	playerid	][   spawned ]==ENABLE) return true;
	else return false;
}

stock IsPlayerDead(playerid)
{
	if(player_info[	playerid	][   dead ]==ENABLE) return true;
	else return false;
}

stock IsPlayerInClassSelection(playerid)
{
	if(player_info[	playerid	][   class ]==ENABLE) return true;
	else return false;
}

stock IsPlayerOnBike(playerid)
{
	if(!IsPlayerInAnyVehicle(playerid)) return false;
	new
	    Bikes[12]=
	    {	581,509,481,421,462,510,463,522,461,448,586,468	},
		vehicleid=GetPlayerVehicleID(playerid);
	for(new i = 0; i < 12; i++)
 	{
    	if(GetVehicleModel(vehicleid) == Bikes[i])
		{   return true;	} else return false;
	}
}

stock IsPlayerInCar(playerid)
{
	if(!IsPlayerInAnyVehicle(playerid)) return false;
	new
	    AllCars[93] =	{
		400,401,402,404,405,410,411,412,415,418,419,420,421,422,424,426,429,434,436,
		438,439,442,445,451,458,466,467,470,474,475,477,478,480,480,480,480,489,490,
		491,492,494,496,500,501,502,503,504,505,506,507,516,517,518,526,527,529,533,
		534,535,536,540,541,542,543,545,546,547,549,550,551,555,558,559,560,561,562,
		565,566,567,575,576,580,585,587,589,596,597,598,600,602,603,604,605	},
		vehicleid=GetPlayerVehicleID(playerid);
	for(new i = 0; i < 93; i++)
 	{
    	if(GetVehicleModel(vehicleid) == AllCars[i])
		{   return true;	} else return false;
	}
}

stock IsPlayerInBoat(playerid)
{
	if(!IsPlayerInAnyVehicle(playerid)) return false;
	new
	    Boats[10] =	{
		472,473,595,493,430,453,484,446,452,454	},
		vehicleid=GetPlayerVehicleID(playerid);
	for(new i = 0; i < 10; i++)
 	{
    	if(GetVehicleModel(vehicleid) == Boats[i])
		{   return true;	} else return false;
	}
}

stock IsPlayerInHelicopter(playerid)
{
	if(!IsPlayerInAnyVehicle(playerid)) return false;
	new
	    Helis[9] =	{
		548,425,488,487,417,563,497,447,469	},
		vehicleid=GetPlayerVehicleID(playerid);
	for(new i = 0; i < 9; i++)
 	{
    	if(GetVehicleModel(vehicleid) == Helis[i])
		{   return true;	} else return false;
	}
}

stock IsPlayerInAircraft(playerid)
{
	if(!IsPlayerInAnyVehicle(playerid)) return false;
	new
	    Aircrafts[20] =	{
		577,511,592,520,593,512,476,553,460,413,519,548,425,488,487,417,563,497,447,469	},
		vehicleid=GetPlayerVehicleID(playerid);
	for(new i = 0; i < 20; i++)
 	{
    	if(GetVehicleModel(vehicleid) == Aircrafts[i])
		{   return true;	} else return false;
	}
}

stock IsPlayerAfk(playerid)
{
	if(player_info[	playerid	][   afk ]==ENABLE) return true;
	else return false;
}

stock IsPlayerInjured(playerid)
{
	new
		Float:hp;
	if(hp<11)
	{   return true;    } else return false;
}

stock IsPlayerGod(playerid)
{
	new
		Float:hp;
	if(hp>100)
	{   return true;    } else return false;
}

stock IsPlayerMale(playerid)
{
	new
		Males[204] =	{
		0,1,2,7,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,32,33,34,35,36,37,43,44,45,46,47,48,
		49,50,51,52,56,58,59,60,61,62,66,67,68,70,71,72,73,78,79,80,81,82,83,84,94,95,96,97,98,99,100,
		101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,120,121,123,124,125,126,
		127,128,132,133,134,135,136,137,142,143,144,146,147,153,154,155,156,158,159,160,161,162,163,164,
		165,166,167,168,170,171,173,174,175,176,177,179,180,181,182,183,184,185,186,187,188,189,200,202,
		203,204,206,209,210,217,220,222,221,223,227,228,229,230,234,235,256,239,240,241,242,247,248,249,
		250,252,253,254,255,258,259,260,261,262,264,265,267,268,269,270,271,272,273,274,275,276,277,
		278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,297,299	};
    for(new i = 0; i < 204; i++)
 	{
    	if(GetPlayerSkin(playerid) == Males[i])
		{   return true;	} else return false;
	}

}

stock IsPlayerFemale(playerid)
{
	if(IsPlayerMale(playerid))
	{   return false;   } else return true;

}

stock IsPlayerInWater(playerid)
{
	new
		animlib[10],
		animname[10];
	GetAnimationName(GetPlayerAnimationIndex(playerid),
					animlib,
					sizeof(animlib),
					animname,
					sizeof(animname));
	return (!strcmp(animlib, "SWIM")) ? 1 : 0;
}

stock IsPlayerOnLand(playerid)
{
	if(IsPlayerInWater(playerid))
	{   return false;   } else return true;
}

Hook:P_OnPlayerConnect(playerid)
{
    SetTimerEx("OnPlayerUpdateEx",
			1000,
			true,
			"i",
			playerid);
	return 1;
}

Hook:P_OnPlayerRequestClass(playerid, classid)
{
	player_info[	playerid	][   spawned ]=DISABLE;
	player_info[	playerid	][   dead ]=DISABLE;
	player_info[	playerid	][   class ]=ENABLE;
	return 1;
}

Hook:P_OnPlayerSpawn(playerid)
{
    player_info[	playerid	][   afktimer ]=0;
 	player_info[	playerid	][   spawned ]=ENABLE;
 	player_info[	playerid	][   dead ]=DISABLE;
 	player_info[	playerid	][   class ]=DISABLE;
 	return 1;
}

Hook:P_OnPlayerDeath(playerid, killerid, reason)
{
	player_info[	playerid	][   spawned ]=DISABLE;
	player_info[	playerid	][   dead ]=ENABLE;
	player_info[	playerid	][   class ]=DISABLE;
	return 1;
}

Hook:P_OnPlayerUpdateEx(playerid)
{
	if(player_info[	playerid	][   afktimer ]<0) return false;
    player_info[	playerid	][   afktimer ]++;
    if(player_info[	playerid	][   afktimer ]>AFK_TIMER)
    {   player_info[	playerid	][   afk ]=ENABLE,
		player_info[	playerid	][   afktimer ]=-1;  }
	return 1;
}

Hook:P_OnPlayerKeyStateChange(playerid, newkeys, oldkeys)
{
    player_info[	playerid	][   afk ]=DISABLE,
	player_info[	playerid	][   afktimer ]=0;
	return 1;
}

